#!/usr/bin/jed -script
variable saubuf = "ytags";

define get_tag()
{
        variable tag = "0-9A-Z_a-z";

        push_spot();
        bskip_chars(tag);
        push_mark();
        skip_chars(tag);
        bufsubstr();   % Leave on stack
        pop_spot();
        % Return value on stack
}

define instobuf(s)
{
	variable old = whatbuf();

	setbuf(saubuf);
	insert(s);
	setbuf(old);
}

define ytags()
{
	variable file, tag, line;

	(file,,,) = getbuf_info();

	bob();
	if (bol_fsearch("%%") == 0)
		return;
	go_down_1();
	push_mark();
	if (bol_fsearch("%%") == 0)
		return;
	go_up_1();
	narrow();
	bob();
	do {
		bol();
		if (re_fsearch("^[a-zA-Z_]") == 0)
			break;

		tag = get_tag();
		line = line_as_string();
		instobuf(tag+"\t"+file+"\t/^"+line+"$/;\"\n");
	} while (down(1));
	widen();
}

define dump_parms()
{
	variable i;

	for (i=0; i < __argc; i++)
		vmessage("%d: %s", i, __argv[i]);
}

define tag_dir()
{
	variable i = 3;

	%dump_parms();
	message("ytags: create a tags file (called ytags) from yacc input files.");
	No_Backups = 1;
	if (__argc <= 3)
	{
		     message ("Usage: jed -script ytags.sl file ...");
		     quit_jed ();
	}

	find_file(saubuf);
	bob();
	push_mark();
	eob();
	call("kill_region");
	write_buffer(saubuf);
	while (i < __argc)
	{
		() = read_file (__argv[i]);
		ytags();
		delbuf (whatbuf());
		i++;
	}

	setbuf(saubuf);
	write_buffer(saubuf);
	quit_jed();
}

tag_dir();
