#!/usr/bin/jed -script

define apply_tag(match, start, end)
{
        bob();
        while(bol_fsearch(match)) {
                bol(); insert(start);
                eol(); insert(end);
        }
}

define quote_chars()
{
        bob();
        replace("&", "&amp;");
        replace("<", "&lt;");
        replace(">", "&gt;");
}

define tagify_diff()
{
        apply_tag("diff ", "<U>", "</U>");
        apply_tag("+++ ",  "<U>", "</U>");
        apply_tag("--- ",  "<U>", "</U>");
        apply_tag("@@ ",  "<U>", "</U>");
        apply_tag("+", "<B><I>", "</I></B>");
        apply_tag("-", "<FONT color=\"#C0C0C0\"><I>", "</I></FONT>");
}

define html_ify()
{
        bob();
        insert("<HTML>\n<PRE>\n");
        eob();
        insert("</PRE>\n</HTML>\n");
}

define modify_buffer()
{
        quote_chars();
        tagify_diff();
        html_ify();
}

define diff2html()
{
        variable i = 3;

        if (__argc <= 3)
        {
                message ("Usage: jed -script diff2html.sl file ...");
                quit_jed ();
        }

        while (i < __argc)
        {
                variable newname = path_sans_extname(__argv[i]) + ".html";

                () = read_file(__argv[i]);
                modify_buffer();
                remove(newname);
                write_buffer(newname);
                delbuf (whatbuf());
                i++;
        }

        quit_jed();

}

diff2html();
